﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private CourseBL _CourseBL = null;

        public CourseBL Course
        {
            get
            {
                if (_CourseBL == null)
                {
                    _CourseBL = new CourseBL(this);
                }

                return _CourseBL;
            }
        }

        public class CourseBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
        {
            public CourseBL(ZSBELearning BL) : base(BL) { }

            public bool IsFinised(BL.ZSBELearning.ContextParam ContextParam)
            {
                bool _isFinished = true;

                if ((ContextParam.CourseType != Dictionary.Category.CourseType.CompetenceTheory) && (ContextParam.Group == Dictionary.GroupType.Student))
                {
                    if (ContextParam.CourseType == Dictionary.Category.CourseType.Case)
                    {
                        foreach (ELearning.BL.BO.View.Unit _loopUnit in ContextParam.Units)
                        {
                            if (_loopUnit.ExerciseTotal.Value > 0)
                            {
                                //decimal _exerciseDonePercent = (_loopUnit.ExerciseDone.Value * 100) / _loopUnit.ExerciseTotal.Value;

                                //if (_loopUnit.ExerciseMaxPointDone == 0 && _exerciseDonePercent < ContextParam.RandomizePercent)
                                //{
                                //    _isFinished = false;
                                //    break;
                                //}

                                int _exerciseToDo = (int)Math.Round((ContextParam.RandomizePercent * _loopUnit.ExerciseTotal.Value) / 100);

                                if (_loopUnit.ExerciseMaxPointDone == 0 && _loopUnit.ExerciseDone.Value < _exerciseToDo)
                                {
                                    _isFinished = false;
                                    break;
                                }
                            }                            
                        }
                    }
                    else
                    {
                        foreach (ELearning.BL.BO.View.Unit _loopUnit in ContextParam.Units)
                        {
                            if (_loopUnit.ExerciseTotal.Value > 0)
                            {
                                //decimal _exerciseDonePercent = (_loopUnit.ExerciseDone.Value * 100) / _loopUnit.ExerciseTotal.Value;

                                //if (_exerciseDonePercent < ContextParam.RandomizePercent)
                                //{
                                //    _isFinished = false;
                                //    break;
                                //}

                                int _exerciseToDo = (int)Math.Round((ContextParam.RandomizePercent * _loopUnit.ExerciseTotal.Value) / 100);

                                if (_loopUnit.ExerciseDone.Value < _exerciseToDo)
                                {
                                    _isFinished = false;
                                    break;
                                }
                            }
                        }
                    }
                }
                else
                {
                    _isFinished = false;
                }

                return _isFinished;
            }

            public int CountExerciseTotal(BL.ZSBELearning.ContextParam ContextParam)
            {
                int _exerciseTotal = 0;

                foreach (ELearning.BL.BO.View.Unit _loopUnit in ContextParam.Units)
                {
                    if (ContextParam.Group == Dictionary.GroupType.Student)
                    {
                        _exerciseTotal += (int)Math.Round((ContextParam.RandomizePercent * _loopUnit.ExerciseTotal ?? 0) / 100);
                    }
                    else
                    {
                        _exerciseTotal += _loopUnit.ExerciseTotal ?? 0;
                    }
                }

                return _exerciseTotal;
            }

            public int CountExerciseDone(BL.ZSBELearning.ContextParam ContextParam)
            {
                int _exerciseDone = 0;

                foreach (ELearning.BL.BO.View.Unit _loopUnit in ContextParam.Units)
                {
                    _exerciseDone += _loopUnit.ExerciseDone ?? 0;
                }

                return _exerciseDone;
            }

            public int CountExerciseMaxPointDone(BL.ZSBELearning.ContextParam ContextParam)
            {
                int _exerciseMaxPointDone = 0;

                foreach (ELearning.BL.BO.View.Unit _loopUnit in ContextParam.Units)
                {
                    _exerciseMaxPointDone += _loopUnit.ExerciseMaxPointDone ?? 0;
                }

                return _exerciseMaxPointDone;
            }
        }
    }
}
